// prefs.c

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "FSp_fopen.h"

#include "main.h"
#include "stringtools.h"
#include "prefs.h"
#include "keyboard.h"
#include "midi.h"
#include "soundfx.h"
#include "hiscore.h"
#include "register.h"

#define kPrefsMaxSize 65536

PrefList prefList[] = {
		{ 'mod ', &musicOn,                    sizeof( Boolean        ) },
		{ 'sfx ', &soundOn,                    sizeof( Boolean        ) },
		{ 'keys', keyCode,                     sizeof( keyCode        ) },
		{ 'size', registeredKey,               sizeof( registeredKey  ) },
		{ 'high', scores,                      sizeof( scores         ) },
		{ 'user', registeredName,              sizeof( registeredName ) },
		{ 'cmbx', &best,                       sizeof( best           ) }
					  };
									

#define kPrefListSize (sizeof(prefList)/sizeof(prefList[0]))


/* Loads the preferences from a file in the System Folder:Preferences. */

void LoadPrefs( void )
{
	FILE *F;
	FSSpec prefsFile;
	int fileSize, count, digitsLeft;
	UInt8 info, *infoAt, *dataAt, *fileData;
	
	FindFolder( kOnSystemDisk, kPreferencesFolderType, kCreateFolder,
		&prefsFile.vRefNum, &prefsFile.parID );
	FSMakeFSSpec( prefsFile.vRefNum, prefsFile.parID, "\pCandy Crisis Preferences", &prefsFile );

	F = FSp_fopen( &prefsFile, "rb" );

	if( F != nil )
	{
		fileData = (UInt8*) NewPtrClear( kPrefsMaxSize );
		
		if( fileData != nil )
		{
			fileSize = fread( fileData, 1, kPrefsMaxSize, F );
		
			if( fileSize >= 0 )
			{
				for( count=0; count<kPrefListSize; count++ )
				{
					infoAt = FindPrefsLine( fileData, fileSize, prefList[count].itemName, prefList[count].size );
					if( infoAt )
					{
						dataAt = (UInt8*) prefList[count].itemPointer;
						digitsLeft = prefList[count].size;
						
						while( digitsLeft-- )
						{
							info  = ((*infoAt >= 'A')? (*infoAt - 'A' + 0xA): (*infoAt - '0')) << 4;
							infoAt++;
							info |= ((*infoAt >= 'A')? (*infoAt - 'A' + 0xA): (*infoAt - '0'));
							infoAt++;
							
							*dataAt++ = info;
						}
					}
				}
			}
			
			DisposePtr( (Ptr)fileData );
		}

		fclose( F );
	}
}

/* Finds a specific line in the prefs. */

UInt8 *FindPrefsLine( UInt8 *prefsText, long prefsLength, long searchCode, long dataQuantity )
{
	UInt8 *prefsAt, *check, *endCheck;
	
	for( prefsAt = prefsText; prefsAt < (prefsText+prefsLength-3); prefsAt++ )
	{
		if( *(long *)prefsAt == searchCode ) 
		{
			prefsAt += 6;
			
			// perform sizing check
			
			dataQuantity *= 2; // hexadecimal bytes are 2 chars
			
			if( ((prefsAt + dataQuantity) - prefsText) > prefsLength ) return nil; // prefs block ended too early
			
			check = prefsAt;
			endCheck = check + dataQuantity;
			while( check < endCheck )
			{
				if( (*check < '0' || *check > '9') && (*check < 'A' || *check > 'F') )
				{
					return nil; // incorrect size, too short
				}
					
				check++;
			}
			
			if( (*endCheck >= '0' && *endCheck <= '9') || (*endCheck >= 'A' && *endCheck <= 'F') )
			{
				return nil; // incorrect size, too long
			}
			
			return prefsAt;
		}
	}
	
	return nil;
}

/* Saves out preferences into a file. */

void SavePrefs( void )
{
	FILE *F;
	FSSpec prefsFile;
	short count, size;
	UInt8 *dataAt;
	
	FindFolder( kOnSystemDisk, kPreferencesFolderType, kCreateFolder,
		&prefsFile.vRefNum, &prefsFile.parID );
	FSMakeFSSpec( prefsFile.vRefNum, prefsFile.parID, "\pCandy Crisis Preferences", &prefsFile );
	
	F = FSp_fopen( &prefsFile, "wb" );
	
	if( F != nil )
	{
		for( count=0; count<kPrefListSize; count++ )
		{
			fwrite( &prefList[count].itemName, 1, 4, F );
			fputc( ':', F );
			fputc( ' ', F );
			
			dataAt = (UInt8*) prefList[count].itemPointer;
			for( size=0; size<prefList[count].size; size++ )
			{
				fputc( "0123456789ABCDEF"[ *dataAt >>  4 ], F );
				fputc( "0123456789ABCDEF"[ *dataAt & 0xF ], F );
				dataAt++;
			}
			
			fputc( '\n', F );
		}
	}
			
	fclose( F );
	
	ChangeTypeAndCreator( &prefsFile, 'Pref', 'Skit' );
}
